Scriptname lbQuestMCMScript Extends SKI_ConfigBase

lbQuestMainScript Property aaaQuestMain Auto
lbQuestMeterScript Property aaaQuestMeter1 Auto
lbQuestMeterScript Property aaaQuestMeter2 Auto
lbQuestMeterScript Property aaaQuestMeter3 Auto

String[] LayoutPresetList
Bool IsAutoLoad
Bool FlipMeter
String JsonFilename = "LimitBreak.json"


Int Function GetVersion()
	return 1
EndFunction


Event OnConfigInit()
	Pages = new String[3]
	Pages[0] = "$LB_Layout"
	Pages[1] = "$LB_HotKey"
	Pages[2] = "$LB_Profile"

	LayoutPresetList = new String[6]
	LayoutPresetList[0] = "$LB_TopCenter"
	LayoutPresetList[1] = "$LB_TopLeft"
	LayoutPresetList[2] = "$LB_TopRight"
	LayoutPresetList[3] = "$LB_BottomCenter"
	LayoutPresetList[4] = "$LB_BottomLeft"
	LayoutPresetList[5] = "$LB_BottomRight"
EndEvent


;/
Event OnVersionUpdate(Int aiVersion)
	if aiVersion >= 2 && CurrentVersion < 2
	endif
EndEvent
/;


Event OnConfigOpen()
	aaaQuestMain.Cleanup()
EndEvent


Event OnConfigClose()
	aaaQuestMain.Setup()
EndEvent


Event OnPageReset(String asPage)
	if asPage == "$LB_HotKey"
		SetCursorFillMode(TOP_TO_BOTTOM)

		AddKeyMapOptionST("KEY_TO_OPEN_MENU", "$LB_KeyToOpenMenu", aaaQuestMain.KeyToOpenMenu, OPTION_FLAG_WITH_UNMAP)
		AddKeyMapOptionST("KEY_TO_TANK_LB",   "$LB_KeyToTankLB",   aaaQuestMain.KeyToTankLB,   OPTION_FLAG_WITH_UNMAP)
		AddKeyMapOptionST("KEY_TO_HEALER_LB", "$LB_KeyToHealerLB", aaaQuestMain.KeyToHealerLB, OPTION_FLAG_WITH_UNMAP)
		AddKeyMapOptionST("KEY_TO_MELEE_LB",  "$LB_KeyToMeleeLB",  aaaQuestMain.KeyToMeleeLB,  OPTION_FLAG_WITH_UNMAP)
		AddKeyMapOptionST("KEY_TO_CASTER_LB", "$LB_KeyToCasterLB", aaaQuestMain.KeyToCasterLB, OPTION_FLAG_WITH_UNMAP)
	elseif asPage == "$LB_Profile"
		if PapyrusUtil.GetVersion() > 1
			AddToggleOptionST("PROFILE_LOAD", "$ProfileLoad", false, GetOptionFlag( JsonUtil.JsonExists(JsonFilename) ) )
			AddToggleOptionST("PROFILE_SAVE", "$ProfileSave", false)
			AddToggleOptionST("IS_AUTO_LOAD", "$IsAutoLoad", IsAutoLoad)
		else
			AddTextOption("$PapyrusUtilNotInstalled", "", OPTION_FLAG_DISABLED)
		endif
	else
		SetCursorFillMode(TOP_TO_BOTTOM)

		AddToggleOptionST("MULTI_METER", "$LB_MultiMeter", aaaQuestMain.MultiMeter)
		AddToggleOptionST("FLIP_METER",  "$LB_FlipMeter",  FlipMeter)
		AddMenuOptionST("LAYOUT_PRESET", "$LB_LayoutPreset", "$Select")

		SetCursorPosition(1)

		AddColorOptionST("METER_COLOR_0", "$LB_MeterColor0", aaaQuestMain.MeterColor0)
		AddColorOptionST("METER_COLOR_1", "$LB_MeterColor1", aaaQuestMain.MeterColor1)
		AddColorOptionST("METER_COLOR_2", "$LB_MeterColor2", aaaQuestMain.MeterColor2)
		AddColorOptionST("METER_COLOR_3", "$LB_MeterColor3", aaaQuestMain.MeterColor3)
	endif
EndEvent


Int Function GetOptionFlag(Bool abBoolean)
	if abBoolean
		return OPTION_FLAG_NONE
	else
		return OPTION_FLAG_DISABLED
	endif
EndFunction


Function ApplyFlip()
	Float fHeight = aaaQuestMeter1.Height
	Float fX1 = aaaQuestMeter1.X
	Float fX2 = aaaQuestMeter2.X
	Float fX3 = aaaQuestMeter3.X
	Float fY = aaaQuestMeter1.Y

	if FlipMeter
		if fHeight > 0
			aaaQuestMeter1.Height = -fHeight
			aaaQuestMeter1.X = fX1 + 260.0
			aaaQuestMeter1.Y = fY + 16.0
			aaaQuestMeter2.Height = -fHeight
			aaaQuestMeter2.X = fX2 + 260.0
			aaaQuestMeter2.Y = fY + 16.0
			aaaQuestMeter3.Height = -fHeight
			aaaQuestMeter3.X = fX3 + 260.0
			aaaQuestMeter3.Y = fY + 16.0
		endif
	else
		if fHeight < 0
			aaaQuestMeter1.Height = -fHeight
			aaaQuestMeter1.X = fX1 - 260.0
			aaaQuestMeter1.Y = fY - 16.0
			aaaQuestMeter2.Height = -fHeight
			aaaQuestMeter2.X = fX2 - 260.0
			aaaQuestMeter2.Y = fY - 16.0
			aaaQuestMeter3.Height = -fHeight
			aaaQuestMeter3.X = fX3 - 260.0
			aaaQuestMeter3.Y = fY - 16.0
		endif
	endif
EndFunction


Function ApplyLayoutPreset(Int aiIndex)
	Float fHeight = 22.0
	Float fX
	Float fY
	String sDirection = "Right"

	if aiIndex == 0
		FlipMeter = true
		fHeight = -fHeight
		fX = 916.0
		fY = 16.0
	elseif aiIndex == 1
		FlipMeter = true
		fHeight = -fHeight
		fX = 662.0
		fY = 16.0
	elseif aiIndex == 2
		FlipMeter = true
		fHeight = -fHeight
		fX = 1170.0
		fY = 16.0
	elseif aiIndex == 3
		FlipMeter = false
		fX = 916.0 - 260.0
		fY = 700.0 - 16.0
	elseif aiIndex == 4
		FlipMeter = false
		fX = 662.0 - 260.0
		fY = 700.0 - 16.0
	elseif aiIndex == 5
		FlipMeter = false
		fX = 1170.0 - 260.0
		fY = 700.0 - 16.0
	endif

	;Debug.Trace(aiIndex + " x=" + fX + " y=" + fY)

	if FlipMeter
		sDirection = "Left"
	endif

	if aaaQuestMain.MultiMeter
		aaaQuestMain.MeterColor0 = 0xFFFF00
		aaaQuestMain.MeterColor1 = 0xFFFF00
		aaaQuestMain.MeterColor2 = 0xFFFF00
		aaaQuestMain.MeterColor3 = 0xFF0000
	else
		aaaQuestMain.MeterColor0 = 0x0000FF
		aaaQuestMain.MeterColor1 = 0xFFFF00
		aaaQuestMain.MeterColor2 = 0x00FF00
		aaaQuestMain.MeterColor3 = 0xFF0000
	endif

	aaaQuestMeter1.FillDirection = sDirection
	aaaQuestMeter1.HAnchor = "Center"
	aaaQuestMeter1.VAnchor = "Top"
	aaaQuestMeter1.Width = 292.000
	aaaQuestMeter1.Height = fHeight
	aaaQuestMeter1.X = fX - 250.0
	aaaQuestMeter1.Y = fY

	aaaQuestMeter2.FillDirection = sDirection
	aaaQuestMeter2.HAnchor = "Center"
	aaaQuestMeter2.VAnchor = "Top"
	aaaQuestMeter2.Width = 292.000
	aaaQuestMeter2.Height = fHeight
	aaaQuestMeter2.X = fX
	aaaQuestMeter2.Y = fY

	aaaQuestMeter3.FillDirection = sDirection
	aaaQuestMeter3.HAnchor = "Center"
	aaaQuestMeter3.VAnchor = "Top"
	aaaQuestMeter3.Width = 292.000
	aaaQuestMeter3.Height = fHeight
	aaaQuestMeter3.X = fX + 250.0
	aaaQuestMeter3.Y = fY

	ApplyMultiMeter()
EndFunction


Function ApplyMultiMeter()
	if aaaQuestMain.MultiMeter
		aaaQuestMeter1.Alpha = 100.0
		aaaQuestMeter2.Alpha = 100.0
		aaaQuestMeter3.Alpha = 100.0
	else
		aaaQuestMeter1.Alpha = 0.0
		aaaQuestMeter2.Alpha = 100.0
		aaaQuestMeter3.Alpha = 0.0
	endif
EndFunction


Function AutoLoad()
	if JsonUtil.JsonExists(JsonFilename)
		if JsonUtil.GetIntValue(JsonFilename, "IsAutoLoad")
			LoadProfile()
			return
		endif
	endif

	ApplyLayoutPreset(0)
EndFunction


Function LoadProfile()
	IsAutoLoad = JsonUtil.GetIntValue(JsonFilename, "IsAutoLoad", 0) as Bool

	aaaQuestMain.KeyToOpenMenu = JsonUtil.GetIntValue(JsonFilename, "KeyToOpenMenu", -1)
	aaaQuestMain.KeyToTankLB   = JsonUtil.GetIntValue(JsonFilename, "KeyToTankLB",   -1)
	aaaQuestMain.KeyToHealerLB = JsonUtil.GetIntValue(JsonFilename, "KeyToHealerLB", -1)
	aaaQuestMain.KeyToMeleeLB  = JsonUtil.GetIntValue(JsonFilename, "KeyToMeleeLB",  -1)
	aaaQuestMain.KeyToCasterLB = JsonUtil.GetIntValue(JsonFilename, "KeyToCasterLB", -1)

	aaaQuestMain.MultiMeter = JsonUtil.GetIntValue(JsonFilename, "MultiMeter", 1) as Bool
	FlipMeter = JsonUtil.GetIntValue(JsonFilename, "FlipMeter", 1) as Bool

	aaaQuestMain.MeterColor0 = JsonUtil.GetIntValue(JsonFilename, "MeterColor0", 0xFFFF00)
	aaaQuestMain.MeterColor1 = JsonUtil.GetIntValue(JsonFilename, "MeterColor1", 0xFFFF00)
	aaaQuestMain.MeterColor2 = JsonUtil.GetIntValue(JsonFilename, "MeterColor2", 0xFFFF00)
	aaaQuestMain.MeterColor3 = JsonUtil.GetIntValue(JsonFilename, "MeterColor3", 0xFF0000)
EndFunction


Function SaveProfile()
	JsonUtil.SetIntValue(JsonFilename, "IsAutoLoad", IsAutoLoad as Int)

	JsonUtil.SetIntValue(JsonFilename, "KeyToOpenMenu", aaaQuestMain.KeyToOpenMenu)
	JsonUtil.SetIntValue(JsonFilename, "KeyToTankLB",   aaaQuestMain.KeyToTankLB)
	JsonUtil.SetIntValue(JsonFilename, "KeyToHealerLB", aaaQuestMain.KeyToHealerLB)
	JsonUtil.SetIntValue(JsonFilename, "KeyToMeleeLB",  aaaQuestMain.KeyToMeleeLB)
	JsonUtil.SetIntValue(JsonFilename, "KeyToCasterLB", aaaQuestMain.KeyToCasterLB)

	JsonUtil.SetIntValue(JsonFilename, "MultiMeter", aaaQuestMain.MultiMeter as Int)
	JsonUtil.SetIntValue(JsonFilename, "FlipMeter", FlipMeter as Int)

	JsonUtil.SetIntValue(JsonFilename, "MeterColor0", aaaQuestMain.MeterColor0)
	JsonUtil.SetIntValue(JsonFilename, "MeterColor1", aaaQuestMain.MeterColor1)
	JsonUtil.SetIntValue(JsonFilename, "MeterColor2", aaaQuestMain.MeterColor2)
	JsonUtil.SetIntValue(JsonFilename, "MeterColor3", aaaQuestMain.MeterColor3)

	JsonUtil.Save(JsonFilename)
EndFunction


State KEY_TO_OPEN_MENU
	Event OnKeyMapChangeST(int newKeyCode, string conflictControl, string conflictName)
		aaaQuestMain.KeyToOpenMenu = newKeyCode
		SetKeyMapOptionValueST(newKeyCode)
	EndEvent

	Event OnDefaultST()
		aaaQuestMain.KeyToOpenMenu = -1
		SetKeyMapOptionValueST(-1)
	EndEvent

	Event OnHighlightST()
		SetInfoText("$LB_KeyToOpenMenuHint")
	EndEvent
EndState


State KEY_TO_TANK_LB
	Event OnKeyMapChangeST(int newKeyCode, string conflictControl, string conflictName)
		aaaQuestMain.KeyToTankLB = newKeyCode
		SetKeyMapOptionValueST(newKeyCode)
	EndEvent

	Event OnDefaultST()
		aaaQuestMain.KeyToTankLB = -1
		SetKeyMapOptionValueST(-1)
	EndEvent

	Event OnHighlightST()
		SetInfoText("LB_KeyToTankLBHint")
	EndEvent
EndState


State KEY_TO_HEALER_LB
	Event OnKeyMapChangeST(int newKeyCode, string conflictControl, string conflictName)
		aaaQuestMain.KeyToHealerLB = newKeyCode
		SetKeyMapOptionValueST(newKeyCode)
	EndEvent

	Event OnDefaultST()
		aaaQuestMain.KeyToHealerLB = -1
		SetKeyMapOptionValueST(-1)
	EndEvent

	Event OnHighlightST()
		SetInfoText("LB_KeyToHealerLBHint")
	EndEvent
EndState


State KEY_TO_MELEE_LB
	Event OnKeyMapChangeST(int newKeyCode, string conflictControl, string conflictName)
		aaaQuestMain.KeyToMeleeLB = newKeyCode
		SetKeyMapOptionValueST(newKeyCode)
	EndEvent

	Event OnDefaultST()
		aaaQuestMain.KeyToMeleeLB = -1
		SetKeyMapOptionValueST(-1)
	EndEvent

	Event OnHighlightST()
		SetInfoText("LB_KeyToMeleeLBHint")
	EndEvent
EndState


State KEY_TO_CASTER_LB
	Event OnKeyMapChangeST(int newKeyCode, string conflictControl, string conflictName)
		aaaQuestMain.KeyToCasterLB = newKeyCode
		SetKeyMapOptionValueST(newKeyCode)
	EndEvent

	Event OnDefaultST()
		aaaQuestMain.KeyToCasterLB = -1
		SetKeyMapOptionValueST(-1)
	EndEvent

	Event OnHighlightST()
		SetInfoText("LB_KeyToCasterLBHint")
	EndEvent
EndState


State MULTI_METER
	Event OnSelectST()
		aaaQuestMain.MultiMeter = !aaaQuestMain.MultiMeter
		SetToggleOptionValueST(aaaQuestMain.MultiMeter)
		ApplyMultiMeter()
	EndEvent
	
	Event OnDefaultST()
		aaaQuestMain.MultiMeter = true
		SetToggleOptionValueST(true)
		ApplyMultiMeter()
	EndEvent

	Event OnHighlightST()
		SetInfoText("$LB_MultiMeterHint")
	EndEvent
EndState


State FLIP_METER
	Event OnSelectST()
		FlipMeter = !FlipMeter
		SetToggleOptionValueST(FlipMeter)
		ApplyFlip()
	EndEvent
	
	Event OnDefaultST()
		FlipMeter = true
		SetToggleOptionValueST(true)
		ApplyFlip()
	EndEvent

	Event OnHighlightST()
		SetInfoText("$LB_FlipMeterHint")
	EndEvent
EndState


State LAYOUT_PRESET
	Event OnMenuOpenST()
		SetMenuDialogStartIndex(0)
		SetMenuDialogDefaultIndex(0)
		SetMenuDialogOptions(LayoutPresetList)
	EndEvent

	Event OnMenuAcceptST(int index)
		SetMenuOptionValueST(LayoutPresetList[index])
		ApplyLayoutPreset(index)
		ForcePageReset()
	EndEvent

	Event OnHighlightST()
		SetInfoText("$LB_LayoutPresetHint")
	EndEvent
EndState


State IS_AUTO_LOAD
	Event OnSelectST()
		IsAutoLoad = !IsAutoLoad
		SetToggleOptionValueST(IsAutoLoad)
	EndEvent
	
	Event OnDefaultST()
		IsAutoLoad = true
		SetToggleOptionValueST(IsAutoLoad)
	EndEvent

	Event OnHighlightST()
		SetInfoText("$IsAutoLoadHint")
	EndEvent
EndState


State PROFILE_SAVE
	Event OnSelectST()
		SetToggleOptionValueST(true)

		if !ShowMessage("$AskProfileSave")
			SetToggleOptionValueST(false)
			return
		endif

		SaveProfile()
		ShowMessage("$ProfileSaved", false)
		SetToggleOptionValueST(false)
	EndEvent

	Event OnHighlightST()
		SetInfoText("$ProfileSaveHint")
	EndEvent
EndState


State PROFILE_LOAD
	Event OnSelectST()
		SetToggleOptionValueST(true)

		if !ShowMessage("$AskProfileLoad")
			SetToggleOptionValueST(false)
			return
		endif

		if JsonUtil.JsonExists(JsonFilename)
			LoadProfile()
			ForcePageReset()
			ShowMessage("$ProfileLoaded", false)
		else
			ShowMessage("$ProfileNotFound", false)
		endif

		SetToggleOptionValueST(false)
	EndEvent

	Event OnHighlightST()
		SetInfoText("$ProfileLoadHint")
	EndEvent
EndState